<?php
// --- SM7 TOURNAMENT SYSTEM V3.0 (With Logos) ---
$dataFile = 'sm7_tournament_data.json';

// Initialize data if not exists
if (!file_exists($dataFile)) {
    $defaults = [];
    for($i=1; $i<=4; $i++) {
        $defaults[$i] = [
            'n1' => "Team A", 'l1' => "", // Name & Logo Team 1
            'n2' => "Team B", 'l2' => "", // Name & Logo Team 2
            'game' => "Match $i",
            's1' => 0, 's2' => 0, 'servNum' => 2, 'servTeam' => 1
        ];
    }
    file_put_contents($dataFile, json_encode($defaults));
}

// Handle Update
if (isset($_POST['update'])) {
    $courtID = $_POST['court'];
    $newData = json_decode($_POST['data'], true);
    $currentData = json_decode(file_get_contents($dataFile), true);
    $currentData[$courtID] = $newData;
    file_put_contents($dataFile, json_encode($currentData));
    echo "Saved";
    exit;
}

// Handle Read
if (isset($_GET['read'])) {
    header('Content-Type: application/json');
    readfile($dataFile);
    exit;
}

$view = isset($_GET['view']) ? $_GET['view'] : 'dashboard';
$activeCourt = isset($_GET['court']) ? $_GET['court'] : 1;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>SM7 Tournament V3</title>
    <style>
        :root { --blue: #0047ab; --gold: #ffd700; --dark: #121212; --card-bg: #1e1e1e; }
        body { font-family: 'Segoe UI', Roboto, sans-serif; margin: 0; background: #f4f4f9; overflow: hidden; }

        /* === UTILS === */
        .logo-img { object-fit: contain; }

        /* === DASHBOARD === */
        <?php if ($view == 'dashboard'): ?>
        body { background: #f0f2f5; overflow-y: auto; }
        #dashboard { padding: 20px; max-width: 800px; margin: 0 auto; }
        .dash-header { text-align: center; margin-bottom: 20px; }
        .btn-public { display: block; width: 100%; text-align: center; background: #333; color: white; padding: 12px; text-decoration: none; border-radius: 8px; margin-bottom: 20px; font-weight: bold; }
        .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        .court-card { 
            background: white; border-radius: 12px; padding: 15px; 
            display: flex; flex-direction: column; align-items: center;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1); text-decoration: none; color: #333;
        }
        .c-title { font-size: 14px; font-weight: bold; color: #888; text-transform: uppercase; }
        .c-score { font-size: 32px; font-weight: 800; color: var(--blue); margin: 5px 0; }
        .c-vs { font-size: 13px; color: #666; display: flex; align-items: center; gap: 5px; }
        .mini-logo { width: 20px; height: 20px; border-radius: 50%; background: #eee; }
        <?php endif; ?>

        /* === PUBLIC SCOREBOARD === */
        <?php if ($view == 'public'): ?>
        body { background: var(--dark); color: white; overflow-y: auto; }
        #public-view { padding: 10px; max-width: 1400px; margin: 0 auto; }
        .pub-header { text-align: center; margin-bottom: 15px; border-bottom: 1px solid #333; padding-bottom: 10px; }
        .pub-header h1 { margin: 0; color: var(--gold); font-size: 24px; text-transform: uppercase; }
        .pub-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 15px; }
        .pub-card { 
            background: var(--card-bg); border-radius: 10px; padding: 15px; border: 1px solid #333; 
            display: flex; flex-direction: column; position: relative;
        }
        .pub-court-label { font-size: 12px; color: var(--gold); font-weight: bold; text-transform: uppercase; margin-bottom: 5px; }
        .pub-match-name { font-size: 14px; color: #888; margin-bottom: 10px; border-bottom: 1px solid #444; padding-bottom: 5px; }
        .pub-row { display: flex; align-items: center; margin-bottom: 8px; padding: 5px 10px; border-radius: 6px; }
        .pub-row.serving { background: rgba(255, 215, 0, 0.15); border-left: 4px solid var(--gold); }
        .pub-logo { width: 40px; height: 40px; border-radius: 50%; background: #fff; margin-right: 10px; padding: 2px; }
        .pub-name { font-size: 18px; font-weight: 600; flex: 1; }
        .pub-score { font-size: 32px; font-weight: 700; color: white; }
        <?php endif; ?>

        /* === CONTROLLER === */
        <?php if ($view == 'control'): ?>
        body { height: 100vh; display: flex; flex-direction: column; }
        #controller { flex: 1; display: flex; flex-direction: column; padding: 10px; gap: 8px; }
        .top-nav { display: flex; align-items: center; }
        .back-link { background: #444; color: white; padding: 5px 12px; border-radius: 4px; text-decoration: none; font-size: 14px; font-weight: bold; }
        .court-id { flex: 1; text-align: center; font-weight: bold; font-size: 18px; color: #333; }
        
        .setup-row { display: flex; gap: 5px; }
        input { padding: 8px; border: 1px solid #ccc; border-radius: 4px; font-size: 14px; }
        .inp-name { flex: 2; font-weight: bold; }
        .inp-logo { flex: 1; font-size: 12px; }
        .inp-game { width: 100%; text-align: center; box-sizing: border-box; }

        .server-bar { background: #222; color: white; padding: 10px; border-radius: 6px; text-align: center; cursor: pointer; }
        .server-bar span { color: var(--gold); font-weight: bold; font-size: 18px; }

        .score-board { display: flex; gap: 8px; flex: 1; min-height: 0; }
        .team-panel { flex: 1; background: white; border-radius: 8px; padding: 10px; display: flex; flex-direction: column; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .tp-name { text-align: center; font-weight: bold; font-size: 18px; margin: 5px 0; overflow: hidden; white-space: nowrap; text-overflow: ellipsis; }
        .tp-logo-preview { width: 40px; height: 40px; margin: 0 auto; object-fit: contain; }
        .tp-score { font-size: 60px; font-weight: 800; text-align: center; color: var(--blue); margin: auto 0; line-height: 1; }
        
        button { border: none; border-radius: 6px; font-weight: bold; cursor: pointer; touch-action: manipulation; }
        button:active { opacity: 0.8; transform: scale(0.96); }
        .btn-add { background: #28a745; color: white; font-size: 30px; padding: 10px; margin-bottom: 5px; }
        .btn-sub { background: #dc3545; color: white; font-size: 20px; padding: 8px; }
        .btn-serve { background: #eee; color: #999; padding: 8px; font-size: 12px; }
        .btn-serve.active { background: var(--blue); color: white; }
        .actions { display: grid; grid-template-columns: 2fr 1fr; gap: 8px; }
        .btn-sideout { background: var(--gold); color: black; padding: 12px; font-size: 18px; }
        .btn-reset { background: #6c757d; color: white; }
        <?php endif; ?>

        /* === OVERLAY === */
        <?php if ($view == 'overlay'): ?>
        body { background: transparent; }
        #overlay { display: flex; width: 100vw; height: 100vh; align-items: flex-end; justify-content: center; padding-bottom: 50px; }
        .ov-board { display: flex; width: 900px; height: 110px; background: rgba(0,0,0,0.9); border: 2px solid white; border-radius: 12px; color: white; overflow: hidden; box-shadow: 0 5px 25px rgba(0,0,0,0.5); }
        .ov-team { flex: 2; display: flex; align-items: center; padding: 0 20px; position: relative; }
        /* Left Team Layout */
        #ot1 { flex-direction: row-reverse; text-align: right; }
        #ot1 .ov-logo { margin-left: 15px; }
        /* Right Team Layout */
        #ot2 { flex-direction: row; text-align: left; }
        #ot2 .ov-logo { margin-right: 15px; }
        
        .ov-logo { width: 70px; height: 70px; object-fit: contain; background: white; border-radius: 50%; padding: 2px; }
        .ov-info { flex: 1; }
        .ov-name { font-size: 22px; font-weight: 700; text-transform: uppercase; line-height: 1.1; }
        .ov-score { font-size: 56px; font-weight: 800; color: var(--gold); line-height: 1; }
        
        .ov-mid { width: 140px; background: #2a2a2a; border-left: 1px solid #555; border-right: 1px solid #555; display: flex; flex-direction: column; align-items: center; justify-content: center; }
        .ov-lbl { font-size: 12px; color: #bbb; text-transform: uppercase; letter-spacing: 1px; }
        .ov-srv { font-size: 42px; font-weight: bold; }
        .ov-dot { width: 14px; height: 14px; background: #0f0; border-radius: 50%; position: absolute; top: 10px; box-shadow: 0 0 10px #0f0; display: none; }
        #ot1 .ov-dot { right: 10px; }
        #ot2 .ov-dot { left: 10px; }
        .ov-serving .ov-dot { display: block; }
        <?php endif; ?>
    </style>
</head>
<body>

<?php if ($view == 'dashboard'): ?>
    <div id="dashboard">
        <div class="dash-header"><h2>🏆 SM7 Tournament Hub</h2></div>
        <a href="?view=public" class="btn-public" target="_blank">Open Public Scoreboard ↗</a>
        <div class="grid" id="dash-grid"></div>
    </div>

<?php elseif ($view == 'public'): ?>
    <div id="public-view">
        <div class="pub-header"><h1>SM7 Live Scores</h1></div>
        <div class="pub-grid" id="pub-grid"></div>
    </div>

<?php elseif ($view == 'control'): ?>
    <div id="controller">
        <div class="top-nav">
            <a href="?view=dashboard" class="back-link">Back</a>
            <div class="court-id">COURT <?php echo $activeCourt; ?></div>
        </div>
        
        <div class="setup-row">
            <input class="inp-name" id="n1" placeholder="Team 1 Name" onchange="push()" value="Team A">
            <input class="inp-logo" id="l1" placeholder="Logo URL 1" onchange="push()">
        </div>
        
        <input class="inp-game" id="game" placeholder="Match Info (e.g. Final)" onchange="push()" value="Match">
        
        <div class="setup-row">
            <input class="inp-name" id="n2" placeholder="Team 2 Name" onchange="push()" value="Team B">
            <input class="inp-logo" id="l2" placeholder="Logo URL 2" onchange="push()">
        </div>

        <div class="server-bar" onclick="togSrv()">
            Server: <span id="disp-s-num">2</span> <small>(Tap to swap)</small>
        </div>

        <div class="score-board">
            <div class="team-panel">
                <button class="btn-serve" id="btn-srv1" onclick="setSrvTeam(1)">SERVE</button>
                <img id="img-prev1" class="tp-logo-preview" src="" onerror="this.style.display='none'" onload="this.style.display='block'">
                <div class="tp-name" id="disp-n1">Team A</div>
                <div class="tp-score" id="disp-s1">0</div>
                <button class="btn-add" onclick="mod(1,1)">+</button>
                <button class="btn-sub" onclick="mod(1,-1)">-</button>
            </div>
            <div class="team-panel">
                <button class="btn-serve" id="btn-srv2" onclick="setSrvTeam(2)">SERVE</button>
                <img id="img-prev2" class="tp-logo-preview" src="" onerror="this.style.display='none'" onload="this.style.display='block'">
                <div class="tp-name" id="disp-n2">Team B</div>
                <div class="tp-score" id="disp-s2">0</div>
                <button class="btn-add" onclick="mod(2,1)">+</button>
                <button class="btn-sub" onclick="mod(2,-1)">-</button>
            </div>
        </div>

        <div class="actions">
            <button class="btn-sideout" onclick="sideOut()">SIDE OUT ⇄</button>
            <button class="btn-reset" onclick="rst()">RESET</button>
        </div>
        <div id="status" style="text-align:center;font-size:11px;color:#999;">Ready</div>
    </div>

<?php elseif ($view == 'overlay'): ?>
    <div id="overlay">
        <div class="ov-board">
            <div class="ov-team" id="ot1">
                <div class="ov-dot"></div>
                <div class="ov-info">
                    <div class="ov-name" id="on1">Team A</div>
                </div>
                <div class="ov-score" id="os1">0</div>
                <img id="ol1" class="ov-logo" src="" onerror="this.style.visibility='hidden'" onload="this.style.visibility='visible'">
            </div>
            <div class="ov-mid">
                <div class="ov-lbl" id="ogame">Final</div>
                <div class="ov-srv" id="osrv">2</div>
                <div class="ov-lbl">SERVER</div>
            </div>
            <div class="ov-team" id="ot2">
                <img id="ol2" class="ov-logo" src="" onerror="this.style.visibility='hidden'" onload="this.style.visibility='visible'">
                <div class="ov-score" id="os2">0</div>
                <div class="ov-info">
                    <div class="ov-name" id="on2">Team B</div>
                </div>
                <div class="ov-dot"></div>
            </div>
        </div>
    </div>
<?php endif; ?>

<script>
    const view = "<?php echo $view; ?>";
    const courtID = "<?php echo $activeCourt; ?>";
    let state = {};

    // --- DASHBOARD JS ---
    if (view === 'dashboard') {
        function tickDash() {
            fetch('?read=1&t='+Date.now()).then(r=>r.json()).then(d => {
                const g = document.getElementById('dash-grid');
                g.innerHTML = '';
                for(let i=1; i<=4; i++) {
                    const c = d[i];
                    // Mini Logo Check
                    const l1 = c.l1 ? `<img src="${c.l1}" class="mini-logo">` : '';
                    const l2 = c.l2 ? `<img src="${c.l2}" class="mini-logo">` : '';
                    
                    g.innerHTML += `
                        <a href="?view=control&court=${i}" class="court-card">
                            <div class="c-title">Court ${i}</div>
                            <div class="c-score">${c.s1} - ${c.s2}</div>
                            <div class="c-vs">${l1} ${c.n1} vs ${c.n2} ${l2}</div>
                        </a>`;
                }
            });
        }
        setInterval(tickDash, 2000); tickDash();
    }

    // --- PUBLIC SCOREBOARD JS ---
    if (view === 'public') {
        function tickPub() {
            fetch('?read=1&t='+Date.now()).then(r=>r.json()).then(d => {
                const g = document.getElementById('pub-grid');
                g.innerHTML = '';
                for(let i=1; i<=4; i++) {
                    const c = d[i];
                    const s1C = c.servTeam == 1 ? 'serving' : '';
                    const s2C = c.servTeam == 2 ? 'serving' : '';
                    
                    // Logo Logic
                    const img1 = c.l1 ? `<img src="${c.l1}" class="pub-logo">` : '';
                    const img2 = c.l2 ? `<img src="${c.l2}" class="pub-logo">` : '';
                    
                    g.innerHTML += `
                        <div class="pub-card">
                            <div class="pub-court-label">COURT ${i}</div>
                            <div class="pub-match-name">${c.game}</div>
                            <div class="pub-row ${s1C}">
                                ${img1}
                                <div class="pub-name">${c.n1}</div>
                                <div class="pub-score">${c.s1}</div>
                            </div>
                            <div class="pub-row ${s2C}">
                                ${img2}
                                <div class="pub-name">${c.n2}</div>
                                <div class="pub-score">${c.s2}</div>
                            </div>
                        </div>`;
                }
            });
        }
        setInterval(tickPub, 3000); tickPub();
    }

    // --- CONTROLLER JS ---
    if (view === 'control') {
        function load() {
            fetch('?read=1&t='+Date.now()).then(r=>r.json()).then(d => {
                state = d[courtID];
                render();
            });
        }
        
        function render() {
            document.getElementById('n1').value = state.n1 || '';
            document.getElementById('n2').value = state.n2 || '';
            document.getElementById('l1').value = state.l1 || '';
            document.getElementById('l2').value = state.l2 || '';
            document.getElementById('game').value = state.game;
            
            document.getElementById('disp-n1').innerText = state.n1;
            document.getElementById('disp-n2').innerText = state.n2;
            document.getElementById('disp-s1').innerText = state.s1;
            document.getElementById('disp-s2').innerText = state.s2;
            document.getElementById('disp-s-num').innerText = state.servNum;

            document.getElementById('img-prev1').src = state.l1 || '';
            document.getElementById('img-prev2').src = state.l2 || '';
            
            document.getElementById('btn-srv1').className = state.servTeam==1 ? 'btn-serve active' : 'btn-serve';
            document.getElementById('btn-srv2').className = state.servTeam==2 ? 'btn-serve active' : 'btn-serve';
        }

        function push() {
            state.n1 = document.getElementById('n1').value;
            state.n2 = document.getElementById('n2').value;
            state.l1 = document.getElementById('l1').value;
            state.l2 = document.getElementById('l2').value;
            state.game = document.getElementById('game').value;
            render();
            
            let fd = new FormData();
            fd.append('update', 1);
            fd.append('court', courtID);
            fd.append('data', JSON.stringify(state));
            document.getElementById('status').innerText = "Syncing...";
            fetch('', {method:'POST', body:fd}).then(() => document.getElementById('status').innerText = "Live");
        }

        function mod(team, v) {
            if(team==1) state.s1 = Math.max(0, state.s1+v);
            if(team==2) state.s2 = Math.max(0, state.s2+v);
            push();
        }
        function setSrvTeam(t) { state.servTeam = t; push(); }
        function togSrv() { state.servNum = state.servNum==1?2:1; push(); }
        function sideOut() {
            state.servTeam = state.servTeam==1?2:1;
            state.servNum = 1;
            push();
        }
        function rst() {
            if(confirm('Reset Court '+courtID+'?')) {
                state.s1=0; state.s2=0; state.servNum=2; state.servTeam=1;
                push();
            }
        }
        load();
    }

    // --- OVERLAY JS ---
    if (view === 'overlay') {
        function tickOv() {
            fetch('?read=1&t='+Date.now()).then(r=>r.json()).then(d => {
                const s = d[courtID];
                document.getElementById('on1').innerText = s.n1;
                document.getElementById('on2').innerText = s.n2;
                document.getElementById('os1').innerText = s.s1;
                document.getElementById('os2').innerText = s.s2;
                document.getElementById('ogame').innerText = s.game;
                document.getElementById('osrv').innerText = s.servNum;
                
                // Update Logos
                const l1 = document.getElementById('ol1');
                const l2 = document.getElementById('ol2');
                if(l1.src.indexOf(s.l1) === -1) l1.src = s.l1 || ''; // Only update if changed
                if(l2.src.indexOf(s.l2) === -1) l2.src = s.l2 || '';
                
                document.getElementById('ot1').classList.remove('ov-serving');
                document.getElementById('ot2').classList.remove('ov-serving');
                if(s.servTeam==1) document.getElementById('ot1').classList.add('ov-serving');
                else document.getElementById('ot2').classList.add('ov-serving');
            });
        }
        setInterval(tickOv, 1000);
    }
</script>
</body>
</html>